# to autoload this file
proc m2GlobAux.tcl {} {}
	

#===========================================================================
#  Global aux routines  #
#===========================================================================

namespace eval M2 {}

#================================================================================
# The following may be useful to generate a make file, e.g. when called like
# this: listDirContent "::RMS:Work:" {*.DEF *.MOD} ".PRJ" 0 "Def Mod;"
# or interactively: listDirContent "" {*.DEF *.MOD} ".PRJ" 0 "Def Mod;"
# or simply: listDirContent, which lists all files in a directory to be
# determined by a user open file dialog
#
# Examples:
# --------
# List non-recursivley only directories starting with letter "F"
#listDirContent "" "F.*" ".LIST" "1" "" "-1"

# List recursively all directories
#listDirContent "" ".*" ".LIST" "1" "" "-1" "1"

# List recursively all files here ending with ".PRJ"
#listDirContent "" ".*\\.PRJ" ".LIST" "1" "" "0" "1"

# List recursively directories and files here ending with ".DEF" or ".MOD" 
# where extra trailing may follow ".MOD"-files, e.g. "HowDoYouDo.MOD (orig.)"
#listDirContent "" ".*DEF .*MOD.*" ".LIST" "1" "" "0" "1"

# List only files (ignore directories) with name "ForClim.MOD"
#listDirContent "" "ForClim.MOD" ".LIST" "1" "" "1" "0"


proc getDirContent {dir {pat ".*"} {fullpath "0"} {dirFiles "0"} {recursive "0"}} {
# Usage dirFiles:  -1   only directories    0   directories and files    1   only files
    set dirName ${dir}${pat}
    set fileList ""
    if {![catch {set dirContent [glob ${dir}*]}]} then {
	foreach tmp $dirContent {
	    if {[file isdirectory ${tmp}]} then {
		    if {${dirFiles} != "1"} then {
			if {(${fullpath} == "") || (${fullpath} == "0")} then {
			    set tmp [file tail $tmp]
			}
			if { [regexp "(^.*)($dirName)($)" ${tmp}] } then {
			    if {${tmp} != ""} then {
				lappend fileList ${tmp}
			    }
			}
		    }
		if {${recursive} == "1"} then {
		    append fileList " "
		    append fileList [getDirContent "${tmp}:" ${pat} ${fullpath} ${dirFiles}]
		} else {
		}
	    } else {
		if {${dirFiles} != "-1"} then {
		    if {(${fullpath} == "") || (${fullpath} == "0")} then {
			set tmp [file tail $tmp]
		    }
		    if { [regexp "(^.*)($dirName)($)" ${tmp}] } then {
			if {${tmp} != ""} then {
			    lappend fileList ${tmp}
			}
		    }
		}
	    }
	}
    }
    return $fileList
}

proc fromWhichDir {prompt} {
    # default dir
    set dir "HD2:Sim:RMS:Work:"
    set dir ""
    if {[catch {set dir [getfile ${prompt} $dir]}]} then {
    }
    set dir "[file dirname $dir]"
    return $dir
}


proc listDirContent {{dir ""} {pat ".*"} {ext ""} {fullpath "0"} {trailer ""} {dirFiles "0"} {recursive "0"}} {
    if {$dir == ""} then {
	if {${pat} != "*"} then {
	    set dir [fromWhichDir "Choose from where to list $pat files"]
	} else {
	    set dir [fromWhichDir "Choose from where to list files"]
	}
	if {$dir == ""} then {
	    # immediately quit routine since dialog cancelled
	    return 0
	}
    }
    set makeFileName "[file tail $dir]"
    if {$ext != ""} then {
	set makeFileName "${makeFileName}${ext}"
    }
    set dir "${dir}:"
    set patList ""
    foreach patEle $pat {
	set nextFileList [getDirContent $dir $patEle $fullpath $dirFiles $recursive]
	if {(${nextFileList} != "") && ([llength nextFileList] > "0")} then {
	    lappend patList $nextFileList
	}
    }
    if {(${patList} != "") && ([llength patList] != "0")} then { 
	new -n "${makeFileName}"
	foreach fileList $patList {
	    foreach f $fileList {
		if {${f} != ""} then {
		    if {${trailer} != ""} then {
			insertText -w "${makeFileName}" "${f} ${trailer}\n"
		    } else {
			insertText -w "${makeFileName}" "${f}\n"
		    }
		}
	    }
	}
    } else {
	alertnote "No files which match pattern '${dir}${pat}'!"
    }	
}


# the menu command of the M2 menu
proc makeProjectFile {} {
    listDirContent "" ".*\\.DEF .*\\.def .*\\.MOD .*\\.mod" ".PRJ"
}


#================================================================================
# Editing files with conditional compilation flags

set someFlagsPresent 0

proc findLineWithStringAndReplace {matchStr newStr} {
	set forward 1
	set dir $forward
	if {![catch {set foundPos [search -s -r 1 -f $dir -i 0 -- "$matchStr" [getPos]]}]} then {
		set start [lindex $foundPos 0]
		set end [lindex $foundPos 1]
		select $start $end
		if {[pos::compare $start != $end]} then {
			replaceText $start $end "${newStr}"
			message "Replaced '${matchStr}' with '${newStr}'"
		} else {
			message "Unexpected error: getPos $start == selEnd $end"
		}
		set nextln [nextLineStart $start]
		goto $nextln
		return 1
	} else {
		return 0
	}
}

proc leftMargin {pos} {
	set curPos [getPos]
	set start [lineStart $pos]
	set end [pos::math [nextLineStart $start] -1]
	set text [getText $start $end ]
	regexp "(^\[ \t\]*)(.*)$" $text all theIndentation rest
	goto $curPos
	return $theIndentation
}


proc findLineWithStrAndReplBegEnd {matchStr newStrBeg newStrEnd} {
	global someFlagsPresent
	set forward 1
	set dir $forward
	if {![catch {set foundPos [search -s -r 1 -f $dir -i 0 -- "$matchStr" [getPos]]}]} then {
		set start [lindex $foundPos 0]
		set end [lindex $foundPos 1]
		select $start $end
		balance
		if {[isSelection]} then {
			set origComment [getText [getPos] [selEnd]]
			set start [lineStart $start]
			set end [pos::math [nextLineStart $start] -1]
			set whiteSpace [leftMargin $start]
			goto $start
			select $start $end
			# alertnote "after select"
			if {[pos::compare $start != $end]} then {
				set someFlagsPresent 1
				replaceText $start $end "${whiteSpace}${newStrBeg}${origComment}${newStrEnd}"
				message "Replaced '${matchStr}' with '${newStrBeg}${origComment}${newStrEnd}'"
			} else {
				message "Unexpected error: getPos $start == selEnd $end"
			}
			set nextln [nextLineStart $start]
			goto $nextln
			# alertnote "at end"
			return 1
		} else {
			select $start $end
			message "Unexpected error: Balance of selection failed"
		}
	} else {
		return 0
	}
}

proc replaceAllStrings {which with} {
	goto [minPos]
	set found 1
	while {$found == 1} {
		set found [findLineWithStringAndReplace "${which}" "${with}"]
	}
}

proc replaceAllVersFlags {which withBeg withEnd} {
	goto [minPos]
	set found 1
	while {$found == 1} {
		set found [findLineWithStrAndReplBegEnd "${which}" "${withBeg}" "${withEnd}"]
	}
}

proc autoEditCurWindow {flag} {
	# Activate compile version matching flag
	# NOTE: There has to be a blank after $flag or match is not unique!!
	replaceAllVersFlags "ENDIF VERSION_${flag} " "" ""
	replaceAllVersFlags "IF VERSION_${flag} " "" ""
}


proc autoEditCompilerFlags {} {
	global m2_TargetPlatform
	global m2_MacCompFlagList
	global m2_IBMCompFlagList
	global m2_SunCompFlagList
	global someFlagsPresent
    set curPosSaved [getPos]
	# Change case of all lower case keywords
	replaceAllStrings "endif version_" "ENDIF VERSION_"
	replaceAllStrings "if version_" "IF VERSION_"
	# Deactivate all
	replaceAllVersFlags " ENDIF VERSION_" ".*) " ""
	replaceAllVersFlags " IF VERSION_" "" " (*. "
    # Activate according to platform by using all appropriate flags
	if {"${m2_TargetPlatform}" == "Mac"} then {
		set flagList ""
		if {[info exists m2_MacCompFlagList] && (${m2_MacCompFlagList} != "")} then {
			set flagList ${m2_MacCompFlagList}
		} else {
			# The following default flags may need adjustment according to release machinery
			lappend flagList "DM"
			lappend flagList "MacMETH"
			lappend flagList "DM_MAC"
			lappend flagList "DM_MAC_OLD"
			lappend flagList "MW_MAC_OLD"
			lappend flagList "AuxLib_68KFPU"
		}
	} elseif {("${m2_TargetPlatform}" == "IBM") && ("${m2_IBMCompFlagList}" != "")} then {
		set flagList ""
		if {[info exists m2_IBMCompFlagList]} then {
			set flagList ${m2_IBMCompFlagList}
		} else {
			# The following default flags may need adjustment according to release machinery
			lappend flagList "DM"
			lappend flagList "STONYBROOK"
			lappend flagList "DM_IBM"
			lappend flagList "AuxLib"
		}
	} elseif {("${m2_TargetPlatform}" == "Sun") && ("${m2_SunCompFlagList}" != "")} then {
		set flagList ""
		if {[info exists m2_SunCompFlagList]} then {
			set flagList ${m2_SunCompFlagList}
		} else {
			# The following default flags may need adjustment according to release machinery
			lappend flagList "BDM"
			lappend flagList "EPC"
			lappend flagList "AuxLib"
		}
	}
    # alertnote "'${flagList}'"
	foreach flag ${flagList} {
		autoEditCurWindow "${flag}"
	}
	if {"${someFlagsPresent}"} then {
		message "Conditional compiler flags for '${m2_TargetPlatform}' activated!"
	} else {
		message "No conditional compiler flags present in current window" 
	}
	goto $curPosSaved
}

#================================================================================
proc firstWord {text} {
	regexp "\[ |\t\]*(\[A-Za-z0-9_\]*)(.*)" $text text firstWd rest
	return $firstWd
}
proc restWord {text} {
	regexp "\[ |\t\]*(\[A-Za-z0-9_\]*)(.*)" $text text firstWd rest
	return $rest
}

#================================================================================
proc currentDate {} {
    set date "[format "%-11s" "[lindex [mtime [now] short] 0]"]"
    set date "[lindex [mtime [now] short] 0]"
	regexp {([0-9]+).([0-9]+).([0-9]+)} $date dummy day month year
	if {[regexp {^[0-9]$} $day]} then {
		set day "0$day"
	}
	if {[regexp {^[0-9]$} $month]} then {
		set month "0$month"
	}
	if {[regexp {^[0-9]$} $year]} then {
		set year "200$year"
	} elseif {[regexp {^[0-8][0-9]$} $year]} then {
		set year "20$year"
	}
	set date "$day/$month/$year"
	return $date
}

#================================================================================
proc currentYear {} {
    set date [currentDate]
	regexp {([0-9]+).([0-9]+).([0-9]+)} $date dummy day month year
	if {[regexp {^9[0-9]$} $year]} then {
		set year "19$year"
	}
	return $year
}

#================================================================================
proc trim {text} {
	return [string trim $text]
}

#================================================================================
# The following proc thanks to Mark Nagata (mailto://nagata@kurims.kyoto-u.ac.jp)
proc showFullName {} {
        message [lindex [winNames -f] 0]
}




# Reporting that end of this script has been reached
message "m2GlobAux.tcl for Programing in Modula-2 loaded"
if {$installDebugFlag} then {
	alertnote "m2GlobAux.tcl for Programing in Modula-2 loaded"
}
